//+------------------------------------------------------------------+
//|                                              TTM Market Flow.mq4 |
//|                                               TradetheMajors.com |
//|                                       service@tradethemajors.com |
//+------------------------------------------------------------------+
#property copyright "TTM"
#property link      "www.tradethemajors.com"
#property indicator_buffers 2

#property indicator_color1 Lime
#property indicator_color2 Magenta

double haOpen[];
double haClose[];
double haHi[];
double haLo[];
double mode[];

double price=0;

extern int limit = 500;
extern int method = 1;
extern int barWidth = 1;
extern int compBars = 6;

double hi[];
double lo[];

#property indicator_chart_window
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(7);
   
   SetIndexBuffer(0,hi);
   SetIndexBuffer(1,lo);
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,barWidth);
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,barWidth);
   SetIndexBuffer(2,haOpen);
   SetIndexBuffer(3,haClose);
   SetIndexBuffer(4,haHi);
   SetIndexBuffer(5,haLo);
   SetIndexBuffer(6,mode);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----
   
   for(int i=limit; i>=0; i--)
   {
      price = (Open[i]+High[i]+Low[i]+Close[i])/4;
   
      if(i == limit)
      {
         haOpen[i] = Open[i]; 
	      haClose[i] = price;
	      haHi[i] = maxList( High[i], haOpen[i], haClose[i]);
         haLo[i] = minList( Low[i], haOpen[i],haClose[i]);
      }
      else
      {
         haClose[i] = price; 
   	   haOpen[i] = (haOpen [i+1] + haClose [i+1])/2 ;
   	   haHi[i] = maxList(High[i], haOpen[i], haClose[i]) ;
   	   haLo[i] = minList(Low[i], haOpen[i], haClose[i]) ;
      }
   }

   for(int m=limit; m>=0; m--)
   {
      if(haClose[m]>haOpen[m])
      mode[m] = 1;
      else
      mode[m] = 2;       
   }
   
   for(int x=limit; x>=0; x--)
   {
      if(method == 1)
      {  
           if(haClose[x]>haOpen[x])
           {
               hi[x]=High[x];
               lo[x]=Low[x];
           }
           else
           {
               hi[x]=Low[x];
               lo[x]=High[x];
           }       
      }
      else if(method == 2)
      {
          bool f = false;
      
          for(int c=x+compBars ;c>x;c--)
          {
              if(
              haOpen[x] <= maxList2(haOpen[c],haClose[c]) && 
              haOpen[x] >= minList2(haOpen[c],haClose[c]) &&
              haClose[x] <= maxList2(haOpen[c],haClose[c]) &&
              haClose[x] >= minList2(haOpen[c],haClose[c]) 
              )
              {
                  if(mode[c] == 1)
                  {
                     hi[x]=High[x];
                     lo[x]=Low[x];
                  }
                  else
                  {
                     hi[x]=Low[x];
                     lo[x]=High[x];
                  }
                 
                  f = true;
              }
          }
          
          if(f)
          continue;
          
          
          
              if(mode[x] == 1)
              {
                  hi[x]=High[x];
                  lo[x]=Low[x];
              }
              else
              {
                 hi[x]=Low[x];
                 lo[x]=High[x];
              }
      }
      else if(method == 3)
      {
          bool f1 = false;
      
          for(int e=x+compBars ;e>x;e--)
          {
              if(
              haOpen[x] <= maxList(haOpen[e],haClose[e],haHi[e]) && 
              haOpen[x] >= minList(haOpen[e],haClose[e],haLo[e]) &&
              haClose[x] <= maxList(haOpen[e],haClose[e],haHi[e]) &&
              haClose[x] >= minList(haOpen[e],haClose[e],haLo[e]) 
              )
              {
                  if(mode[e] == 1)
                  {
                     hi[x]=High[x];
                     lo[x]=Low[x];
                  }
                  else
                  {
                     hi[x]=Low[x];
                     lo[x]=High[x];
                  }
                 
                  f1 = true;
              }
          }
          
          if(f1)
          continue;
          
             if(mode[x] == 1)
              {
                  hi[x]=High[x];
                  lo[x]=Low[x];
              }
              else
              {
                 hi[x]=Low[x];
                 lo[x]=High[x];
              }
       }
   }   
   
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
double maxList(double v1, double v2, double v3)
{
   double tmp[3];
   tmp[0] = v1;
   tmp[1] = v2;
   tmp[2] = v3;
   return (tmp[ArrayMaximum(tmp,WHOLE_ARRAY,0)]);
}

double minList(double v1, double v2, double v3)
{
   double tmp[3];
   tmp[0] = v1;
   tmp[1] = v2;
   tmp[2] = v3;
   return (tmp[ArrayMinimum(tmp,WHOLE_ARRAY,0)]);
}

double maxList2(double v1, double v2 )
{
   double tmp[2];
   tmp[0] = v1;
   tmp[1] = v2;
   return (tmp[ArrayMaximum(tmp,WHOLE_ARRAY,0)]);
}

double minList2(double v1, double v2 )
{
   double tmp[2];
   tmp[0] = v1;
   tmp[1] = v2;
   return (tmp[ArrayMinimum(tmp,WHOLE_ARRAY,0)]);
}



